﻿using UnityEngine;
using System.Collections;

public class LVL3_Buttons : StoryEvent
{
    public Transform m_Brick;

    public PhysicButton[] m_Buttons;
    public Diode[] m_Diodes;

    public override void StartStory()
    {
        base.StartStory();
        StartCoroutine("C_Buttons");
    }

    private IEnumerator C_Buttons()
    {
        bool puzzleDone = false;

        // Wait for puzzle end
        while (!puzzleDone)
        {
            foreach (PhysicButton button in m_Buttons)
            {
                if (button.IsPushed)
                {
                    Debug.Log("Button : " + button.name);
                    for(int i=0; i<button.SetDiodeValue.Length; ++i)
                    {
                        // Switch off
                        if (button.SetDiodeValue[i] == 0)
                        {
                            m_Diodes[i].SetOn(false);
                        }
                        // Switch on/off
                        if (button.m_SetDiodeValue[i] == 1)
                        {
                            if (m_Diodes[i].IsOn) m_Diodes[i].SetOn(false);
                            else m_Diodes[i].SetOn(true);
                        }
                    }
                }
            }

            puzzleDone = AllDiodesAreOn();

            yield return 0;
        }

        Timer timer = new Timer(1f);
        timer.Start();
        Vector3 initPos = m_Brick.position;
        Vector3 finalPos = initPos + new Vector3(0f,0f,1f);

        while (!timer.UpdateTime())
        {
            m_Brick.position = Vector3.Lerp(initPos, finalPos, timer.GetHermiteProgress());
        }
        m_Brick.position = finalPos;

        m_Finished = true;
    }

    private bool AllDiodesAreOn()
    {
        bool result = true;
        foreach (Diode diode in m_Diodes)
        {
            if (!diode.IsOn) result = false;
        }

        return result;
    }
}